---
title: DDoS attack coverage · Cloudflare DDoS Protection docs
description: The DDoS Attack Protection managed rulesets provide protection
  against a variety of DDoS attacks across L3/4 (layers 3/4) and L7 of the OSI
  model. Cloudflare constantly updates these managed rulesets to improve the
  attack coverage, increase the mitigation consistency, cover new and emerging
  threats, and ensure cost-efficient mitigations.
lastUpdated: 2025-08-18T14:27:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ddos-protection/about/attack-coverage/
  md: https://developers.cloudflare.com/ddos-protection/about/attack-coverage/index.md
---

The [DDoS Attack Protection managed rulesets](https://developers.cloudflare.com/ddos-protection/managed-rulesets/) provide protection against a variety of DDoS attacks across L3/4 (layers 3/4) and L7 of the OSI model. Cloudflare constantly updates these managed rulesets to improve the attack coverage, increase the mitigation consistency, cover new and emerging threats, and ensure cost-efficient mitigations.

[Advanced TCP Protection](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/overview/advanced-tcp-protection/) and [Advanced DNS Protection](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/overview/advanced-dns-protection/), available to [Magic Transit](https://developers.cloudflare.com/magic-transit/) customers, provide additional protection against sophisticated TCP-based DDoS attacks and sophisticated and fully randomized DNS attacks, respectively.

As a general guideline, various Cloudflare products operate on different open systems interconnection (OSI) layers and you are protected up to the layer on which your service operates. You can customize the DDoS settings on the layer in which you onboarded. For example, since the CDN/WAF service is a Layer 7 (HTTP/HTTPS) service, Cloudflare provides protection from DDoS attacks on L7 downwards, including L3/4 attacks.

Note

For Magic Transit customers, Cloudflare provides some L7 protection with a L3 service (like the Advanced DNS Protection system that is available for Magic Transit customers. DNS is considered a L7 protocol).

The following table includes a sample of covered attack vectors:

| OSI Layer | Ruleset / Feature | Example of covered DDoS attack vectors |
| - | - | - |
| L3/4 | [Network-layer DDoS Attack Protection](https://developers.cloudflare.com/ddos-protection/managed-rulesets/network/) | ACK floods BitTorrent reflection attack Carpet Bombing attacks CHARGEN reflection attacks DNS amplification attack DNS Garbage Flood DNS NXDOMAIN flood DNS Query flood DTLS amplification attacks ESP flood GRE floods ICMP flood attack Jenkins amplification attacks Lantronix reflection attacks mDNS DDoS attacks Memcached amplification attacks Mirai and Mirai-variant L3/4 attacks MSSQL reflection attacks NetBios DDoS attacks Out of state TCP attacks Protocol violation attacks QUIC flood attack Quote of the Day (QOTD) reflection attacks RST flood SIP attacks SNMP flood attack SPSS reflection attacks SSDP reflection attacks SYN floods SYN-ACK reflection attack TeamSpeak 3 floods Ubiquity reflection attacks UDP flood attack VxWorks DDoS attacks For more DNS protection options, refer to [Getting additional DNS protection](https://developers.cloudflare.com/ddos-protection/about/attack-coverage/#getting-additional-dns-protection). |
| L3/4 | [Advanced TCP Protection](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/overview/advanced-tcp-protection/) [1](#user-content-fn-1) | Fully randomized and spoofed ACK floods, SYN floods, SYN-ACK reflection attacks, and other sophisticated TCP-based DDoS attacks |
| L7 (DNS) | [Advanced DNS Protection](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/overview/advanced-dns-protection/) [1](#user-content-fn-1) | Sophisticated and fully randomized DNS attacks, including Water Torture attacks, Random-prefix attacks, and DNS laundering attacks. |
| L7 (HTTP/S) | [HTTP DDoS Attack Protection](https://developers.cloudflare.com/ddos-protection/managed-rulesets/http/) | Cache busting attacks Carpet Bombing attacks HTTP Continuation flood HTTP flood attack HTTP/2 MadeYouReset HTTP/2 Rapid Reset HULK attack Known DDoS botnets LOIC attack Mirai and Mirai-variant HTTP attacks Slowloris attack TLS/SSL exhaustion attacks TLS/SSL negotiation attacks WordPress pingback attack  |

## Footnotes

1. Available to Magic Transit customers. [↩](#user-content-fnref-1) [↩2](#user-content-fnref-1-2)

## Getting additional DNS protection

The Network-layer DDoS Attack Protection managed ruleset provides protection against some types of DNS attacks.

Magic Transit customers have access to [Advanced DNS Protection](https://developers.cloudflare.com/ddos-protection/advanced-ddos-systems/overview/advanced-dns-protection/) Beta. Other customers might consider the following options:

* Use Cloudflare as your authoritative DNS provider ([primary DNS](https://developers.cloudflare.com/dns/zone-setups/full-setup/) or [secondary DNS](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-secondary/)).
* If you are running your own nameservers, use [DNS Firewall](https://developers.cloudflare.com/dns/dns-firewall/) to get additional protection against DNS attacks like random prefix attacks.
