---
title: Glossary · Cloudflare DNS docs
description: Review the definitions for terms used across Cloudflare's DNS documentation.
lastUpdated: 2024-10-30T14:03:50.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/dns/glossary/
  md: https://developers.cloudflare.com/dns/glossary/index.md
---

Review the definitions for terms used across Cloudflare's DNS documentation.

| Term | Definition |
| - | - |
| active zone | A DNS zone that is active on Cloudflare requires changing its nameservers to Cloudflare's for management. |
| apex domain | Apex domain is used to refer to a domain that does not contain a subdomain part, such as `example.com` (without `www.`). It is also known as "root domain" or "naked domain". |
| DNS over HTTPS | DNS over HTTPS (DoH) is a standard for encrypting DNS traffic via the HTTPS protocol, preventing tracking and spoofing of DNS queries. |
| DNS over TLS | DNS over TLS (DoT) is a standard for encrypting DNS traffic using its own port (`853`) and TLS encryption. |
| DNS record | DNS records are instructions that live in authoritative DNS servers and provide information about a domain, including what IP address is associated with that domain and how to handle requests for that domain. |
| DNS server | DNS servers translate human-readable domain names into IP addresses, eliminating the need to remember complex IP addresses. |
| DNS zone | A portion of the DNS namespace that is managed by a specific organization or administrator. |
| Domain Name System (DNS) | The Domain Name System (DNS) is the phonebook of the Internet. DNS translates domain names to IP addresses. |
| EDNS Client Subnet (ECS) | ECS is a DNS extension that enables recursive DNS resolvers to include client IP address information in their DNS queries.Not all resolvers use ECS but, if they do, usually a part of the IP address is omitted. Sending ECS headers is generally intended to reduce latency and speed up content delivery in connection to [CDNs](https://developers.cloudflare.com/glossary/?term=cdn) and [load balancers](https://www.cloudflare.com/learning/performance/what-is-load-balancing/). The ECS mechanism is specified in [RFC 7871](https://www.rfc-editor.org/rfc/rfc7871.html). |
| hostname | The name given to a server or node on a network, often the public DNS name of a server. |
| nameserver | A nameserver is a dedicated server that translates human readable hostnames (`www.example.com`) into IP addresses.Nameservers like root servers, TLD servers, and [authoritative nameservers](https://developers.cloudflare.com/dns/nameservers/) are fundamental components of the Domain Name System (DNS). |
| partial setup | Also known as CNAME setup, a partial setup allows you to use Cloudflare's reverse proxy without using Cloudflare for your authoritative nameservers. |
| proxy status | The proxy status of a DNS record defines whether requests for your domain will route through Cloudflare (`proxied`) or not (`DNS-only`).When a [DNS record is proxied](https://developers.cloudflare.com/dns/proxy-status/), requests are processed according to your configurations, and Cloudflare can optimize, cache, and protect your domain. Refer to [How Cloudflare works](https://developers.cloudflare.com/fundamentals/concepts/how-cloudflare-works/) for details. |
| zone apex | Zone apex refers to the domain or subdomain on which the control of DNS records starts. |
