---
title: Email dispositions · Cloudflare Learning Paths
description: "Email security returns five potential verdicts for every email it
  scans. Review the detections and consider how you would treat them once an
  auto-move is enabled. Below is an overview of the disposition and
  recommendation actions by Cloudflare:"
lastUpdated: 2025-10-27T15:00:52.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/secure-o365-email/enable-auto-moves/email-dispositions/
  md: https://developers.cloudflare.com/learning-paths/secure-o365-email/enable-auto-moves/email-dispositions/index.md
---

Email security returns five potential verdicts for every email it scans. Review the detections and consider how you would treat them once an auto-move is enabled. Below is an overview of the disposition and recommendation actions by Cloudflare:

| Disposition | Description | Recommendation | |
| - | - | - | - |
| MALICIOUS | Traffic invoked multiple phishing verdict triggers, met thresholds for bad behavior, and is associated with active campaigns. | Block | |
| SUSPICIOUS | Traffic associated with phishing campaigns (and is under further analysis by our automated systems). | Research these messages internally to evaluate legitimacy. | |
| SPOOF | Traffic associated with phishing campaigns that is either non-compliant with your email authentication policies ([SPF](https://www.cloudflare.com/en-gb/learning/dns/dns-records/dns-spf-record/), [DKIM](https://www.cloudflare.com/en-gb/learning/dns/dns-records/dns-dkim-record/), [DMARC](https://www.cloudflare.com/en-gb/learning/dns/dns-records/dns-dmarc-record/)), or have mismatching Envelope From and Header From values. | Block after investigating (can be triggered by third-party mail services). | |
| SPAM | Traffic associated with non-malicious, commercial campaigns. | Route to existing Spam quarantine folder. | |
| BULK | Traffic associated with [Graymail](https://en.wikipedia.org/wiki/Graymail), that falls in between the definitions of SPAM and SUSPICIOUS. For example, a marketing email that intentionally obscures its unsubscribe link. | Monitor or tag | |
