---
title: http.request.body.form · Cloudflare Ruleset Engine docs
description: The HTTP request body of a form represented as a Map (or associative array).
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.form/
  md: https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.form/index.md
---

# http.request.body.form

`http.request.body.form` Map\<Array\<String>>

The HTTP request body of a form represented as a Map (or associative array).

Populated when the `Content-Type` header is `application/x-www-form-urlencoded`.

The values are not pre-processed and retain the original case used in the request.

When a field repeats, then the array contains multiple items in the order they are in the request.

The return value may be truncated if [`http.request.body.truncated`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.truncated) is `true`.

* **Decoding**: No decoding performed
* **Whitespace**: Preserved
* **Non-ASCII**: Preserved

Requires a Cloudflare Enterprise plan with a paid add-on.

Example value:

```txt
{username": ["admin"]}
```

Example usage:

```txt
any(http.request.body.form["username"][*] == "admin")
```

Warning

All `http.request.body.*` fields (except [`http.request.body.size` ](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.size/)) handle a given maximum body size, which varies per plan. For Enterprise customers, the maximum body size analyzed by Cloudflare is 128 KB; for lower Cloudflare plans, the maximum size is lower. You cannot define expressions that rely on request body data beyond the maximum size set for your plan. If the request body is larger, the body fields will contain a truncated value and the [`http.request.body.truncated` ](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.truncated/)field will be set to `true`. The [`http.request.body.size` ](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.body.size/)field will contain the full size of the request without any truncation.

The maximum body size applies only to the values of HTTP body fields — the origin server will still receive the complete request body.

Categories:

* Request
* Body
