---
title: Troubleshooting · Cloudflare Style Guide
description: This troubleshooting strategy outlines our approach to
  troubleshooting content that is specific to a product or platform.
lastUpdated: 2025-06-24T21:05:23.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/troubleshooting/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/troubleshooting/index.md
---

This troubleshooting strategy outlines our approach to troubleshooting content that is specific to a product or platform.

## Purpose

The purpose of Troubleshooting content is to provide guidance for solving common and corner-case problems with the product.

## Tone

Guiding, straightforward, solution-oriented

## content\_type

```yaml
pcx_content_type: troubleshooting
```

For more details, refer to [`pcx_content_type`](https://developers.cloudflare.com/style-guide/frontmatter/custom-properties/#pcx_content_type).

## Structure

### Required components

[**Title**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/titles/): Troubleshooting name of product or feature

### Optional components

[**Context**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/context/)

[**Steps/Tasks/Procedures**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/steps-tasks-procedures/)

[**Examples**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/examples/)

**Next steps**

## Template

```plaintext
---
weight: xx
pcx_content_type: troubleshooting
---


# Troubleshooting


An introductory paragraph is not required but may be worthwhile if there is a lot of information on this page.


## Concise noun title


Explanation of how to address this issue.


## Concise noun title


Explanation of how to address this issue.
```

## Additional information

In general, create a unique Troubleshooting section for your product. If the Troubleshooting steps are minimal, include the guidance on one Troubleshooting page.

If there are several Troubleshooting steps, create separate pages for logical groupings of Troubleshooting.
